<?php
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../middleware.php';
require_once __DIR__ . '/../util.php';

requireApiKeyOrJwt();
requireMethod('GET');

$user_id = getAuthUserId();
if (!$user_id) {
  jsonResponse(['user' => null, 'auth' => 'api_key'], 200);
}

$stmt = $pdo->prepare('SELECT id, nome, email, created_at, updated_at FROM usuarios WHERE id = ?');
$stmt->execute([$user_id]);
$user = $stmt->fetch();
jsonResponse(['user' => $user, 'auth' => 'jwt']);
