<?php
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../util.php';

requireMethod('POST');
$input = getJsonBody();
$nome = trim($input['nome'] ?? '');
$email = trim($input['email'] ?? '');
$senha = strval($input['senha'] ?? '');

if ($nome === '' || $email === '' || $senha === '') {
  jsonResponse(['error' => 'Campos obrigatórios: nome, email, senha'], 400);
}

$hash = password_hash($senha, PASSWORD_DEFAULT);
$stmt = $pdo->prepare('INSERT INTO usuarios (nome, email, password_hash) VALUES (?, ?, ?)');
try {
  $stmt->execute([$nome, $email, $hash]);
  jsonResponse(['ok' => true, 'id' => $pdo->lastInsertId()]);
} catch (Throwable $e) {
  jsonResponse(['error' => 'Falha ao registrar usuário', 'detail' => $e->getMessage()], 500);
}
