<?php
// middleware.php - API Key e JWT
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/jwt.php';

function requireApiKeyOrJwt() {
  // Se API_KEY estiver vazia, só JWT; se não, aceita qualquer um válido.
  $auth = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
  $bearerOk = false;
  if (stripos($auth, 'Bearer ') === 0) {
    $token = trim(substr($auth, 7));
    list($payload, $err) = jwt_decode($token);
    if (!$err && $payload && isset($payload['sub'])) {
      $GLOBALS['_auth_user_id'] = intval($payload['sub']);
      $bearerOk = True;
    }
  }

  if ($bearerOk) return;

  if (API_KEY !== '') {
    if (stripos($auth, 'Bearer ') === 0) {
      $alt = trim(substr($auth, 7));
      if (hash_equals(API_KEY, $alt)) return;
    }
    if (!empty($_GET['key']) && hash_equals(API_KEY, $_GET['key'])) return;
  }

  http_response_code(401);
  echo json_encode(['error' => 'Unauthorized']);
  exit;
}

function getAuthUserId() {
  return isset($GLOBALS['_auth_user_id']) ? intval($GLOBALS['_auth_user_id']) : null;
}
