<?php
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../middleware.php';
require_once __DIR__ . '/../util.php';

requireApiKeyOrJwt();
requireMethod('GET');

$usuario_id = $_GET['usuario_id'] ?? null;
$usuario = $_GET['usuario'] ?? null;
$authUserId = getAuthUserId();

if ($authUserId && !$usuario_id && !$usuario) {
  $usuario_id = $authUserId;
}

$where = "DATE(data_hora) = CURDATE()";
$params = [];

if ($usuario_id) { $where .= " AND usuario_id = ?"; $params[] = $usuario_id; }
if ($usuario)    { $where .= " AND usuario = ?";     $params[] = $usuario; }

$sql = "SELECT * FROM pontos WHERE $where ORDER BY data_hora DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
jsonResponse($stmt->fetchAll());
