<?php
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../middleware.php';
require_once __DIR__ . '/../util.php';

// Permitir criar usuários apenas com API Key ou JWT (admin futuramente)
requireApiKeyOrJwt();
requireMethod('POST');

$input = getJsonBody();
$nome = trim($input['nome'] ?? '');
$email = trim($input['email'] ?? '');
$senha = $input['senha'] ?? null;

if ($nome === '') {
  jsonResponse(['error' => 'Campo "nome" é obrigatório'], 400);
}

if ($email === '' && $senha) {
  jsonResponse(['error' => 'Para definir senha, informe email'], 400);
}

if ($senha && strlen($senha) < 6) {
  jsonResponse(['error' => 'Senha deve ter pelo menos 6 caracteres'], 400);
}

if ($email !== '') {
  $hash = $senha ? password_hash($senha, PASSWORD_DEFAULT) : null;
  $stmt = $pdo->prepare("INSERT INTO usuarios (nome, email, password_hash) VALUES (?, ?, ?)");
  try {
    $stmt->execute([$nome, $email, $hash]);
    jsonResponse(['ok' => true, 'id' => $pdo->lastInsertId()]);
  } catch (Throwable $e) {
    jsonResponse(['error' => 'Falha ao criar usuário', 'detail' => $e->getMessage()], 500);
  }
} else {
  // sem email/senha
  $stmt = $pdo->prepare("INSERT INTO usuarios (nome) VALUES (?)");
  try {
    $stmt->execute([$nome]);
    jsonResponse(['ok' => true, 'id' => $pdo->lastInsertId()]);
  } catch (Throwable $e) {
    jsonResponse(['error' => 'Falha ao criar usuário', 'detail' => $e->getMessage()], 500);
  }
}
