<?php
// util.php
function jsonResponse($data, int $status = 200) {
  http_response_code($status);
  echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
  exit;
}

function requireMethod(string $method) {
  if (strtoupper($_SERVER['REQUEST_METHOD']) !== strtoupper($method)) {
    jsonResponse(['error' => 'Method not allowed'], 405);
  }
}

function getJsonBody() {
  $raw = file_get_contents('php://input');
  $data = json_decode($raw, true);
  return is_array($data) ? $data : [];
}

function param($name, $default = null) {
  return $_GET[$name] ?? $_POST[$name] ?? $default;
}
